% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{convert_names_data}
\alias{convert_names_data}
\title{Convert column names in a data frame}
\usage{
convert_names_data(
  data,
  dd,
  name_from = "name",
  name_to,
  ignore_cols = union(get_id_cols_abcd(), get_id_cols_hbcd()),
  skip_sep_check = FALSE
)
}
\arguments{
\item{data}{tibble. The input data frame with columns to be renamed.}

\item{dd}{tibble. The data dictionary table. One can use \code{\link[=get_dd]{get_dd()}} family of
functions to get the data dictionary for a given study and release or
provide a custom data dictionary.}

\item{name_from}{character. The column name type in the data dictionary that
the columns in \code{data} currently use (Default: \code{"name"}). This column
must exist in the data dictionary.}

\item{name_to}{character. The column name type in the data dictionary
that the columns in \code{data} should be renamed to. This column
must exist in the data dictionary.}

\item{ignore_cols}{character vector. The columns to ignore (Default:
identifier columns used in ABCD and HBCD).}

\item{skip_sep_check}{logical. Whether to skip the check for
\code{name_to} column's separators validation.
In our official data dictionaries, some columns have
multiple names separated by a \code{"|"} in the same cell.

For columns with multiple names, it the recommended to use functions like
\code{\link[tidyr:separate_rows]{tidyr::separate_rows()}} to split the names into multiple
rows and decide which name to use for the renaming by filtering the rows,
so that the \code{name_from} and \code{name_to} columns are one-to-one
mapping.

If \code{skip_sep_check = FALSE} (default), the function will check if the
\code{name_from} or \code{name_to} columns have the \code{"|"} separator and will throw
an error if the separator is found. If \code{skip_sep_check = TRUE}, it means
you understand that character strings with \code{"|"} inside will be used for
rename mapping, and the function will not check for the separator.}
}
\value{
tibble. The data with renamed column names.
}
\description{
This function renames columns in a data frame to another type of column name
specified in the data dictionary.

For example, this can be used to convert the ABCD column names introduced in
the 6.0 release to the previously used column names. If you instead want to
convert the column names in a file, use \code{\link[=convert_names_file]{convert_names_file()}}.

Note: Please use this function with caution and make sure that the data in
the converted column is equivalent to the data in the original column. Also,
please make sure that the names can be mapped one-to-one. Some variables in
the ABCD data dictionary have been collapsed from previous releases and thus
might have multiple names in the \code{name_to} column that map to a single name
(see \code{skip_sep_check} argument below).
}
\examples{
\dontrun{
# rename columns to previous ABCD names used by NDA
convert_names_data(
  data,
  dd = get_dd("abcd"),
  name_from = "name",
  name_to = "name_nda"
)

# rename columns to Stata names
convert_names_data(
  data,
  dd = get_dd("abcd"),
  name_from = "name",
  name_to = "name_stata"
)
}
}
