% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPoly.R
\name{getPoly}
\alias{getPoly}
\title{Refine Polynomial Order in Latent Growth Modelling (LGM)}
\usage{
getPoly(lgm_object, wd = "Results")
}
\arguments{
\item{lgm_object}{A LGM \code{mplusObject}, typically generated with the \code{LGMobject} and \code{runLGM} functions.}

\item{wd}{A character string specifying the directory where the results folder will be created for saving Mplus input, output, and data files.
Default is the current working directory.}
}
\value{
A LGM \code{mplusObject} including the results of the updated model with the refined polynomial order.
}
\description{
Refine the polynomial order for each class of a LGM
by iteratively removing non-significant growth factors, and running the updated models.
}
\details{
The \code{getPoly} function refines the polynomial order of a LGM \code{mplusObject} through an iterative process.
In addition to ensuring the statistical significance of growth factors in each latent class,
the function ensure that the best loglikelihood value of the updated model is replicated.

The function works as follows:
\itemize{
\item 1. Extract model information from the provided LGM \code{mplusObject}.
\item 2. Evaluate the statistical significance of the highest-order growth factor in each class.
\item 3. Remove non-significant growth factors (p-value > 0.05) from the model.
\item 4. Update the LGM \code{mplusObject} to reflect changes in the growth factor structure.
\item 5. Re-run the updated \code{mplusObject} until log-likelihood values are successfully replicated using the \code{runLGM} function.
\item 6. Repeat the process until the highest-order growth factor of all classes are statistically significant or reduce to intercept-only.
}

The function automates the procedure outlined for model selection in:
Van Der Nest et al,. (2020). "An overview of mixture modelling for latent evolutions in longitudinal data: Modelling approaches, fit statistics and software."
Advances in Life Course Research 43: 100323.
}
\examples{
\donttest{
# Example usage:
final_model <- getPoly(
  lgm_object = LCGA_best,
  wd = "Results"
  )

final_fit <- getFit(final_model)

 print(final_fit)
}
}
\seealso{
\code{\link{LGMobject}} for creating the mplusObject of a latent growth model.
\code{\link{runLGM}} for conducting latent growth modelling with a mplusObject.
}
