% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitLCGA.R
\name{fitLCGA}
\alias{fitLCGA}
\title{Fit Latent Class Growth Analysis (LCGA) models to refine covariance structure.}
\usage{
fitLCGA(
  data,
  outvar,
  catvar = FALSE,
  idvar,
  k,
  starting_val = 500,
  polynomial = 1,
  timescores,
  timescores_indiv = FALSE,
  estimator = c("MLR", "ML", "WLSMV", "WLS"),
  transformation = c("LOGIT", "PROBIT"),
  output = c("TECH1", "TECH11", "SAMPSTAT", "STANDARDIZED"),
  plot = "PLOT3",
  save = "FSCORES",
  wd = "Results"
)
}
\arguments{
\item{data}{A data frame containing all variables for the trajectory analysis.}

\item{outvar}{A character vector specifying the outcome variables at different times.}

\item{catvar}{A logical value indicating whether the outcome variable is categorical. Default is \code{FALSE}.}

\item{idvar}{A character string specifying the ID variable.}

\item{k}{An integer specifying the number of latent classes for the model.}

\item{starting_val}{A numeric value specifying the number of random starting values to generate for the initial optimization stage.
Note that the number of final stage optimizations will be set as equal to half of this value.}

\item{polynomial}{An integer specifying the order of the polynomial used to model trajectories. Supported values are:
1 (linear), 2 (quadratic), 3 (cubic). Default is 1.}

\item{timescores}{A numeric vector specifying the time scores for the model. If \code{timescores_indiv = TRUE},
a character vector should be used to specify variables with individually varying times of observation.}

\item{timescores_indiv}{A logical value indicating whether to use individually varying times of observation for the outcome variable. Default is \code{FALSE}.}

\item{estimator}{A character string to specify the estimator to use in the analysis. Default is 'MLR'.}

\item{transformation}{A character string to specify the latent response variable transformation to use when the outcome variable is categorical. Default is \code{LOGIT}.}

\item{output}{A character vector specifying the requested Mplus output options for the model.}

\item{plot}{A character string specifying the requested Mplus plot options for the model.}

\item{save}{A character string specifying the type of results to be saved by Mplus.}

\item{wd}{A character string specifying the directory where the results folder will be created for saving Mplus input, output, and data files.
Default is the current working directory.}
}
\value{
A list of \code{mplusObject} including results for the fitted LCGA models.
}
\description{
Refine the residual variance structure by fitting a series of LCGA models
progressively allowing for the dependence of residuals on time and/or class,
and returning a list of fitted models for evaluation and comparison.
}
\details{
The \code{fitLCGA} function automates the process of fitting LCGA models, iterating through 3 varying residual variance specifications:
\itemize{
\item - Relaxed residual variance across time
\item - Relaxed residual variance across class
\item - Relaxed residual variance across both time and class
}
This function is designed to help identify the optimal residual variance structure while examining convergence issues as model complexity increases.

The function operates as follows:
\itemize{
\item 1. Iterate over the 3 residual variance specifications
\item 2. Create LCGA \code{mplusObject} with appropriate residual variance specification using the \code{LGMobject} function.
\item 3. Fit models using the \code{runLGM} function, ensuring convergence by increasing the number of random starting values until the best log-likelihood is replicated.
\item 4. Return a list of \code{mplusObject} including results for the fitted LCGA models with each residual variance structures
}

The function automates the procedure outlined for model selection in:
Van Der Nest et al., (2020). "An overview of mixture modelling for latent evolutions in longitudinal data: Modelling approaches, fit statistics and software."
Advances in Life Course Research 43: 100323.

This function builds upon the capabilities of the \code{\link[MplusAutomation]{mplusObject}} and \code{\link[MplusAutomation]{mplusModeler}} functions
from the MplusAutomation package.
}
\examples{
\donttest{
# Example usage:
LCGA_models <- fitLCGA(
 data = symptoms,
 outvar = paste('sx', seq(from = 0, to = 24, by = 6), sep = "_"),
 catvar = FALSE,
 idvar = "id",
 starting_val = 500,
 k = 3L,
 timescores = seq(from = 0, to = 24, by = 6),
 timescores_indiv = FALSE,
 polynomial = 3,
 output = c('TECH1', 'TECH14', 'SAMPSTAT', 'STANDARDIZED'),
 wd = file.path('Results', 'Trajectories')
)

# Accessing the models:
LCGA_t <- LCGA_models[[1]] #with relaxed residual variance across time
LCGA_c <- LCGA_models[[2]] #with relaxed residual variance across class
LCGA_tc <- LCGA_models[[3]] #with relaxed residual variance across time and class
}
}
\seealso{
\code{\link{LGMobject}} for creating the mplusObject of a latent growth model.
\code{\link{runLGM}} for conducting latent growth modelling with an mplusObject.
}
