% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inscribeEllipse.r
\name{inscribeEllipse}
\alias{inscribeEllipse}
\title{Inscribe the maximum ellipse into any arbitrary 2D polygon}
\usage{
inscribeEllipse(poly, step = 0.3, iters = 999)
}
\arguments{
\item{poly}{k x 2 matrix containing ordered coordinates forming the polygon. If outline is not closed, the function will close it.}

\item{step}{stepsize}

\item{iters}{integer: number of iterations to run}
}
\value{
\item{center}{ center of ellipse}
\item{radius.x}{ x-dim of ellipse}
\item{radius.y}{ y-dim of ellipse}
\item{maxarea}{area of ellipse}
}
\description{
Inscribe the maximum ellipse into any arbitrary 2D polygon
}
\examples{
require(shapes)
require(DescTools)
poly <- gorf.dat[c(1,6:8,2:5),,1]
\dontrun{
myellipse <- inscribeEllipse(poly,iters = 200)
plot(poly,asp=1)
lines(rbind(poly,poly[1,]))
DrawEllipse(x=myellipse$center[1],y=myellipse$center[2],radius.x=myellipse$radius.x,
            radius.y = myellipse$radius.y,col="red")
} 
}
