% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subsample.R
\name{subsample}
\alias{subsample}
\title{Subsample a dataset}
\usage{
subsample(pco, sample = NULL, type = "seq")
}
\arguments{
\item{pco}{a \code{regions_pco} object; the output of a call to \code{\link[=svdPCO]{svdPCO()}}.}

\item{sample}{\code{numeric}; either the number or proportion of vertebrae to remain the sampled dataset. If \code{NULL}, the original dataset is returned.}

\item{type}{string; the type of subsampling to do, either \code{"seq"} for sampling in sequence or \code{"random"} for random sampling. Default is \code{"seq"}. Abbreviations allowed.}
}
\value{
A \code{regions_pco} object, a subset of the original supplied to \code{pco}. The original dataset is stored as an attribute, which itself contains the subsampling indices.
}
\description{
\code{subsample()} creates a smaller version of the original dataset by sampling its rows. Because PCOs should be computed on the full dataset and most other functions take in \code{regions_pco} objects, \code{subsample()} requires a \code{regions_pco} object as its input.
}
\examples{
data("alligator")

alligator_data <- process_measurements(alligator,
                                       pos = "Vertebra")

# Compute PCOs
alligator_PCO <- svdPCO(alligator_data)

# Plot vertebrae before subsampling
plotvertmap(alligator_PCO, dropNA = FALSE,
            text = TRUE)

# Subsample data after estimating PCOs; subsample down
# to 15 vertebrae
alligator_PCO_sample <- subsample(alligator_PCO,
                                  sample = 15)

# Plot vertebrae after subsampling; gray vertebrae
# have been dropped
plotvertmap(alligator_PCO_sample, dropNA = FALSE,
            text = TRUE)
}
\seealso{
\code{\link[=svdPCO]{svdPCO()}}, \code{\link[=process_measurements]{process_measurements()}}, \code{\link[=plotvertmap]{plotvertmap()}} to visualize the vertebral map after subsampling.
}
