% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelselect.R
\name{modelselect}
\alias{modelselect}
\title{Select the best models}
\usage{
modelselect(results, scores = NULL)
}
\arguments{
\item{results}{a \code{regions_results} object; the output of a call to \code{calcregions()} or \code{addregions()}.}

\item{scores}{\code{numeric}; a vector corresponding to the indices of the PCOs the \eqn{R^2} of which will be used to determine the best model for each number of regions. If \code{NULL}, the default, all PCOs used included in the fitting will be used.}
}
\value{
A \code{regions_modelselect} object, which contains information about the best models for each number of regions extracted from \code{results}.
}
\description{
\code{modelselect()} narrows down the search for the best model by identifying the best model for each number of regions as determined by its residual sums of squares (RSS).
}
\examples{
data("alligator")

alligator_data <- process_measurements(alligator,
                                       pos = "Vertebra")

# Compute PCOs
alligator_PCO <- svdPCO(alligator_data)

# Fit segmented regression models for 1 to 7 regions
# using PCOs 1 to 4 and a continuous model with a
# non-exhaustive search
regionresults <- calcregions(alligator_PCO,
                             scores = 1:4,
                             noregions = 7,
                             minvert = 3,
                             cont = TRUE,
                             exhaus = FALSE,
                             verbose = FALSE)

regionresults

# For each number of regions, identify best
# model based on minimizing RSS
bestresults <- modelselect(regionresults)
bestresults

# Evaluate support for each model and rank models
supp <- modelsupport(bestresults)
supp

# 5 regions best based on AICc; 6 regions based on BIC
}
\seealso{
\code{\link[=modelsupport]{modelsupport()}} for computing statistics that describe the support of each model using information criteria; \code{\link[=modelperf]{modelperf()}} for computing fit statistics for selected models.
}
