% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCOload.R
\name{PCOload}
\alias{PCOload}
\alias{plot.regions_pco_load}
\title{Calculate PCO loadings}
\usage{
PCOload(x, scores)

\method{plot}{regions_pco_load}(x, ...)
}
\arguments{
\item{x}{for \code{PCOload()}, a \code{regions_pco} object; the output of a call to \code{\link[=svdPCO]{svdPCO()}}. For \code{plot()}, a \code{regions_pco_load} object.}

\item{scores}{a numeric vector containing the indices of the desired scores.}

\item{\dots}{ignored.}
}
\value{
\code{PCOload()} returns a \code{regions_pco_load} object, which is a matrix with a column for each PCO score requested and a row for each variable in the original dataset; values indicate the correlation between each variable and each PCO score. \code{plot()} returns a \code{ggplot} object, which can be manipulated using \emph{ggplot2} syntax, that displays the loadings visually.
}
\description{
\code{PCOload()} computes the loadings for each principal coordinates (PCOs) analysis score, which are the correlations between the features used to compute the PCOs and the PCOs.
}
\details{
the loadings for a constructed variable, \code{vert.size}, are also computed and displayed. This is computed as the mean of the features for each vertebra.
}
\examples{
data("alligator")

alligator_data <- process_measurements(alligator,
                                       pos = "Vertebra")

# Compute PCOs
alligator_PCO <- svdPCO(alligator_data)

# Compute PCO loadings
loadings <- PCOload(alligator_PCO, scores = 1:4)
loadings

# Plot loadings
plot(loadings)
}
\seealso{
\code{\link[=svdPCO]{svdPCO()}} for computing the PCOs; \code{\link[=plot.regions_pco]{plot.regions_pco()}} for visualizing the correlations between PCO scores.
}
