% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mult-clust.R
\name{CLUST}
\alias{CLUST}
\alias{CLUST.default}
\alias{CLUST.Coe}
\title{Hierarchical clustering}
\usage{
CLUST(x, ...)

\method{CLUST}{default}(x, ...)

\method{CLUST}{Coe}(
  x,
  fac,
  type = c("horizontal", "vertical", "fan")[1],
  k,
  dist_method = "euclidean",
  hclust_method = "complete",
  retain = 0.99,
  labels,
  lwd = 1/4,
  cex = 1/2,
  palette = pal_qual,
  ...
)
}
\arguments{
\item{x}{a \link{Coe} or \link{PCA} object}

\item{...}{useless here}

\item{fac}{factor specification for \link{fac_dispatcher}}

\item{type}{\code{character} one of \code{c("horizontal", "vertical", "fan")} (default: \code{horizontal})}

\item{k}{\code{numeric} if provided and greater than 1, cut the tree into this number of groups}

\item{dist_method}{to feed \link{dist}'s \code{method} argument, that is one of
\code{euclidean} (default), \code{maximum}, \code{manhattan}, \code{canberra}, \code{binary} or \code{minkowski}.}

\item{hclust_method}{to feed \link{hclust}'s \code{method} argument, one of
\code{ward.D}, \code{ward.D2}, \code{single}, \code{complete} (default), \code{average}, \code{mcquitty}, \code{median} or \code{centroid}.}

\item{retain}{number of axis to retain if a \link{PCA} object is passed. If a number < 1 is passed, then the number of PCs retained
will be enough to capture this proportion of variance via \link{scree_min}}

\item{labels}{factor specification for labelling tips and to feed \link{fac_dispatcher}}

\item{lwd}{for branches (default: \code{0.25})}

\item{cex}{for labels (default: \code{1})}

\item{palette}{one of available \link{palettes}}
}
\value{
a \code{ggplot} plot
}
\description{
Performs hierarchical clustering through \link{dist} and \link{hclust}. So far it is mainly
a wrapper around these two functions, plus plotting using the \code{dendextend} package facilities.
}
\examples{
# On Coe
bf <- bot \%>\% efourier(6)
CLUST(bf)
# with a factor and vertical
CLUST(bf, ~type, "v")
# with some cutting and different dist/hclust methods
CLUST(bf,
      dist_method="maximum", hclust_method="average",
      labels=~type, k=3, lwd=1, cex=1, palette=pal_manual(c("green", "yellow", "red")))

# On PCA
bf \%>\% PCA \%>\% CLUST

}
\seealso{
Other multivariate: 
\code{\link{KMEANS}()},
\code{\link{KMEDOIDS}()},
\code{\link{LDA}()},
\code{\link{MANOVA}()},
\code{\link{MANOVA_PW}()},
\code{\link{MDS}()},
\code{\link{MSHAPES}()},
\code{\link{NMDS}()},
\code{\link{PCA}()},
\code{\link{classification_metrics}()}
}
\concept{multivariate}
