% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.trafo.p.R
\name{get.trafo.p}
\alias{get.trafo.p}
\title{Export parametrization of fixed effects}
\usage{
get.trafo.p(
  population,
  database = NULL,
  gen = NULL,
  cohorts = NULL,
  id = NULL,
  use.id = TRUE,
  include = NULL
)
}
\arguments{
\item{population}{Population list}

\item{database}{Groups of individuals to consider for the export}

\item{gen}{Quick-insert for database (vector of all generations to export)}

\item{cohorts}{Quick-insert for database (vector of names of cohorts to export)}

\item{id}{Individual IDs to search/collect in the database}

\item{use.id}{Set to TRUE to use MoBPS ids instead of Sex_Nr_Gen based names (default: FALSE)}

\item{include}{Which observations to include in the calculation (default: NULL (all))}
}
\value{
Parameter input used in the transformation function
}
\description{
Function to export parametrization of the fixed effects in transformation function
}
\examples{
data(ex_pop)
get.trafo.p(ex_pop, gen = 2)
}
