% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvmm-class.R
\docType{class}
\name{cvmm-class}
\alias{cvmm-class}
\alias{cvmm}
\alias{show,cvmm-method}
\alias{summary,cvmm-method}
\alias{plot,cvmm,ANY-method}
\alias{cvmm-method}
\title{The cvmm Class.}
\usage{
\S4method{show}{cvmm}(object)

\S4method{summary}{cvmm}(object, which = 1)

\S4method{plot}{cvmm,ANY}(x, y, which = 1, ...)
}
\arguments{
\item{object}{A CVMSpecificCoxPh class object}

\item{which}{This specify which taxon for which estimated HR information need to be visualized. By default results of the first taxon is used.}

\item{x}{A CVMSpecificCoxPh class object \code{\link[MicrobiomeSurv]{CVMSpecificCoxPh}}}

\item{y}{missing}

\item{...}{The usual extra arguments to generic functions — see \code{\link[graphics]{plot}}, \code{\link[graphics]{plot.default}}}
}
\description{
Class of object returned by function \code{\link[MicrobiomeSurv]{CVMSpecificCoxPh}}.
}
\details{
plot signature(x = "cvmm"): Plots for \code{\link[MicrobiomeSurv]{CVMSpecificCoxPh}} class analysis results.

Any parameters of \code{\link[graphics]{plot.default}} may be passed on to this particular plot method.
}
\section{Slots}{

\describe{
\item{\code{HRTrain}}{A 3-way array, The first dimension is the number of taxa, the second dimension is the HR statistics for the low risk group in the train dataset (HR,1/HR LCI, UCI) while the third dimension is the number of cross validation performed.}

\item{\code{HRTest}}{A 3-way array, The first dimension is the number of taxa, the second dimension is the HR statistics for the low risk group in the test dataset (HR,1/HR LCI, UCI) while the third dimension is the number of cross validation performed.}

\item{\code{train}}{The selected subjects for each CV in the train dataset.}

\item{\code{test}}{The selected subjects for each CV in the test dataset.}

\item{\code{n.mi}}{The number of taxa used in the analysis.}

\item{\code{Ncv}}{The number of cross validation performed.}

\item{\code{Rdata}}{The microbiome data matrix that was used for the analysis either same as Micro.mat or a reduced version}
}}

\seealso{
\code{\link[MicrobiomeSurv]{CVMSpecificCoxPh}}
}
\author{
Thi Huyen Nguyen, \email{thihuyen.nguyen@uhasselt.be}

Olajumoke Evangelina Owokotomo, \email{olajumoke.x.owokotomo@gsk.com}

Ziv Shkedy
}
