% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{prop_stronger_sign}
\alias{prop_stronger_sign}
\title{Return sign test point estimate of proportion of effects above or below threshold.}
\usage{
prop_stronger_sign(
  q,
  yi,
  vi,
  ci.level = 0.95,
  tail = NA,
  R = 2000,
  return.vectors = FALSE
)
}
\arguments{
\item{q}{Population effect size that is the threshold for "scientific importance"}

\item{yi}{Study-level point estimates}

\item{vi}{study-level variances}

\item{ci.level}{Confidence level as a proportion}

\item{tail}{\code{above} for the proportion of effects above \code{q}; \code{below} for
the proportion of effects below \code{q}.}

\item{R}{Number of simulation iterates to estimate null distribution of sign test statistic}

\item{return.vectors}{Should all percents and p-values from the grid search be returned?}
}
\description{
Internal function not intended for user to call. Uses an extension of the sign test method of Wang et al. (2010) to estimate the proportion of true (i.e., population parameter) effect sizes in a meta-analysis
that are above or below a specified threshold of scientific importance. See important caveats in the Details section of the documentation for
the function \code{prop_stronger}.
}
\references{
Wang R, Tian L, Cai T, & Wei LJ (2010). Nonparametric inference procedure for percentiles
of the random effects distribution in meta-analysis. \emph{Annals of Applied Statistics}.
}
