\name{Update_row_clusters_REMAXINT}
\alias{Update_row_clusters_REMAXINT}
\title{
Update Row Cluster Assignments in REMAXINT clustering method
}
\description{
Updates the row cluster assignments for a fixed column clustering and G matrix in the REMAXINT clustering framework, using a maximum likelihood strategy.
}
\usage{
Update_row_clusters_REMAXINT(DC, I, J, P, Updated_R, Updated_C, Updated_G)
}
\arguments{
  \item{DC}{
  The data matrix of dimensions \code{I} × \code{J}, representing the doubly centering input data to be clustered.
  }
  \item{I}{
  The number of rows (objects) in the data matrix (DC).
  }
  \item{J}{
  The number of columns (features/conditions) in the data matrix (DC).
  }
  \item{P}{
  The number of row clusters.
  }
  \item{Updated_R}{
  The current binary row cluster membership matrix of size \code{I × P}, where each row has a 1 in the assigned cluster (column).
  }
  \item{Updated_C}{
  The fixed binary column cluster membership matrix of size \code{J × Q}.
  }
  \item{Updated_G}{
  The matrix representing latent interactions between row and column clusters of size \code{P × Q}.
  }
}
\details{
The function iteratively evaluates each row in the data matrix and reassigns it to the cluster that maximizes the log-likelihood under the REMAXINT model. 
Rows assigned to singleton clusters are not re-evaluated. The function avoids assigning rows to clusters with only one member (singleton clusters) to prevent 
degenerate solutions.
}
\value{
Returns an updated row cluster membership matrix of the same dimension as \code{Updated_R}, where each row is reassigned based on the maximum likelihood estimate given the current column clustering and 
latent interactions between row and column clusters of size size \code{P × Q}. This matrix has:
  \item{Updated_R}{The updated binary row cluster membership matrix.}
}
\references{
Ahmed, Z., van Breukelen, G. J. P., Schepers, J., & Cassese, A. (2025). Robustness study of normality-based likelihood ratio tests 
for testing maximal interaction two-mode clustering and a permutation based alternative. \emph{Available on OSF} 
(submitted to Advances in Data Analysis and Classification).
Ahmed, Z., van Breukelen, G. J. P., Schepers, J., & Cassese, A. (2023). E-ReMI: extended maximal interaction two-mode clustering. 
\emph{Journal of Classification, 40,  298-331}
Ahmed, Z., van Breukelen, G. J. P., Schepers, J., & Cassese, A. (2021). REMAXINT: a two-mode clustering-based method for statistical
inference on two-way interaction. \emph{Advances in Data Analysis and Classification, 15(4), 987-1013}
}
\author{
Zaheer Ahmed (ahmed@ifado.de), 
Jan Schepers (jan.schepers@maastrichtuniversity.nl),
Uwe Ligges (ligges@statistik.tu-dortmund.de), 
Alberto Cassese (alberto.cassese@unifi.it), 
Gerard van Breukelen (gerard.vbreukelen@maastrichtuniversity.nl), 
Katja Ickstadt (ickstadt@statistik.tu-dortmund.de), 
Edmund Wascher (wascher@ifado.de)
}
\note{
Used internally by the REMAXINT model fitting procedure. Assumes fixed column cluster membership and updates row assignments to maximize model fit.
}
\seealso{
\code{\link{REMAXINT}}, \code{\link[pracma]{pinv}}
}
\examples{
I <- 10; P <- 4; J <- 5; Q <- 2
DC <- matrix(rnorm(I*J), I, J)
Updated_R <- diag(1, I, P)
Updated_C <- diag(1, J, Q)
R_pinv <- pracma::pinv(t(Updated_R) \%*\% Updated_R)
C_pinv <- pracma::pinv(t(Updated_C) \%*\% Updated_C)
Updated_G <- R_pinv \%*\% t(Updated_R) \%*\% DC \%*\% Updated_C \%*\% C_pinv
Updated_G <- as.matrix(Updated_G)
result <- Update_row_clusters_REMAXINT(DC, I, J, P, Updated_R, Updated_C, Updated_G)
result
}
\keyword{updating row cluster membership in E-ReMI}
