#' Assembly function: Power function
#'
#' This function evaluates the power function \deqn{f(x_1,x_2,\ldots,x_k)=(\sum_{i=1}^kc_ix_{i})^{c_{k+1}}.}
#'
#' @param parameter The value of the parameters \eqn{x_1,x_2,\ldots,x_k}.
#' @param coefficient The value of the coefficients \eqn{c_1,c_2,\ldots,c_k,c_{k+1}}.
#'
#' @return
#' Value of the power function.
#'
#' @keywords internal
#' @noRd
Power<-function(parameter,coefficient)
{
  return(sum(parameter*coefficient[-length(coefficient)])^coefficient[length(coefficient)])
}
