% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FDRSU.R
\name{MBY.p.adjust}
\alias{MBY.p.adjust}
\title{The adjusted p-values for Modified Benjamini-Yekutieli (BY) step-up FDR controlling procedure.}
\usage{
MBY.p.adjust(p, p.set, alpha, make.decision)
}
\arguments{
\item{p}{numeric vector of p-values (possibly with \code{\link[base]{NA}}s). Any other R is coerced by \code{\link[base]{as.numeric}}. Same as in \code{\link[stats]{p.adjust}}.}

\item{p.set}{a list of numeric vectors, where each vector is the vector of all attainable p-values containing the available p-value for the corresponding hypothesis.}

\item{alpha}{significant level used to compare with adjusted p-values to make decisions, the default value is 0.05.}

\item{make.decision}{logical; if  \code{TRUE}, then the output include the decision rules compared adjusted p-values with significant level \eqn{\alpha}}
}
\value{
A numeric vector of the adjusted p-values (of the same length as \code{p}).
}
\description{
The function for calculating the adjusted p-values based on original available p-values and all attaianble p-values.
}
\examples{
p <- c(pbinom(1,8,0.5),pbinom(1,5,0.75),pbinom(1,6,0.6))
p.set <-list(pbinom(0:8,8,0.5),pbinom(0:5,5,0.75),pbinom(0:6,6,0.6))
MBY.p.adjust(p,p.set)
}
\references{
Benjamini, Y., and Yekutieli, D. (2001).
The control of the false discovery rate in multiple testing under dependency.
\emph{Annals of Statistics}, \strong{29}: 1165-1188.
}
\seealso{
\code{\link{MBH.p.adjust}},  \code{\link{MBL.p.adjust}}
}
\author{
Yalin Zhu
}
