% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PN-epi-node-decoupled-P.R
\name{spn_P_epi_decoupled_node}
\alias{spn_P_epi_decoupled_node}
\title{Make Places (P) For a Node (SEI Mosquitoes). Note in the v2 epi module, we only
use the SPN framework for the mosquito component of the model. The human compoenent
will be handled separately in the sampler, and will be formulated as an ODE.
This function makes the set of places (P) for a SPN. It is used alone if our model
is a single-node metapopulation for mosquito SEI and dynamics; This is used by both
SIS and Imperial transmission models.}
\usage{
spn_P_epi_decoupled_node(params, cube)
}
\arguments{
\item{params}{a named list of parameters (see details)}

\item{cube}{an inheritance cube from the \code{MGDrivE} package (e.g. \code{\link[MGDrivE]{cubeMendelian}})}
}
\value{
a list with two elements: \code{ix} contains labeled indices of the places
by life stage, \code{u} is the character vector of places (P)
}
\description{
The \code{params} argument supplies all of the ecological parameters necessary
to calculate equilibrium values. This function requires the \code{nE},
\code{nL}, \code{nP}, and \code{nEIP} parameters to be specified. For more details, see
\code{\link{equilibrium_SEI_SIS}}
}
\details{
For examples of using this function, see:
\code{vignette("epi-node", package = "MGDrivE2")}
}
