% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Layers.R
\name{lbbnn_linear}
\alias{lbbnn_linear}
\title{Class to generate an LBBNN feed forward layer}
\usage{
lbbnn_linear(
  in_features,
  out_features,
  prior_inclusion,
  standard_prior,
  density_init,
  flow = FALSE,
  num_transforms = 2,
  hidden_dims = c(200, 200),
  device = "cpu",
  bias_inclusion_prob = FALSE,
  conv_net = FALSE
)
}
\arguments{
\item{in_features}{integer, number of input neurons.}

\item{out_features}{integer, number of output neurons.}

\item{prior_inclusion}{numeric scalar, prior inclusion probability
for each weight and bias in the layer.}

\item{standard_prior}{numeric scalar, prior standard deviation
for weights and biases in each layer.}

\item{density_init}{A numeric of size 2,
used to initialize the inclusion parameters, one for each layer.}

\item{flow}{logical, whether to use normalizing flows}

\item{num_transforms}{integer, number of transformations for \code{flow}.
Default is 2.}

\item{hidden_dims}{numeric vector, dimension of the hidden layer(s)
in the neural networks of the RNVP transform.}

\item{device}{The device to be used. Default is CPU.}

\item{bias_inclusion_prob}{logical, determines whether the bias
should be as associated with inclusion probabilities.}

\item{conv_net}{logical, whether the layer is used in a convolutional net.}
}
\value{
A \code{torch::nn_module} object,
representing a fully connected LBBNN layer.
The module has the following methods:
\itemize{
\item \code{forward(input, MPM = FALSE)}: Computes activation
(using the LRT at training time) of a batch of inputs.
\item \code{kl_div()}: Computes the KL-divergence.
\item \code{sample_z()}: Samples from the flow if \code{flow = TRUE},
in addition returns the log-determinant of the Jacobian
of the transformation.
}
}
\description{
This module implements a fully connected LBBNN layer.
It supports:
\itemize{
\item Prior inclusion probabilities for weights and biases in each layer.
\item Standard deviation priors for weights and biases in each layer.
\item Optional normalizing flows (RNVP) for a more flexible posterior.
\item Forward pass using either the full model,
or the Median Probability Model (MPM).
\item Computation of the KL-divergence.
}
}
\examples{
\donttest{
l1 <- lbbnn_linear(in_features = 10,out_features = 5,prior_inclusion = 0.25,
standard_prior = 1,density_init = c(0,1),flow = FALSE)
x <- torch::torch_rand(20,10,requires_grad = FALSE)
output <- l1(x,MPM = FALSE) #the forward pass, output has shape (20,5)
print(l1$kl_div()$item()) #compute KL-divergence after the forward pass
}
}
