% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_data.R
\name{model_pdf}
\alias{model_pdf}
\title{Evalulate the probability density function under the model.}
\usage{
model_pdf(x, later_mu, later_sd, early_sd = NULL, log = FALSE)
}
\arguments{
\item{x}{Vector of quantiles}

\item{later_mu}{Vector of the mean of the later component.}

\item{later_sd}{Vector of the standard deviation of the later component.}

\item{early_sd}{Vector of the standard deviation of the early component,
or \code{NULL} if there is no early component (the default).}

\item{log}{If \code{TRUE}, probabilities are given as \code{log(p)}.}
}
\value{
Vector of probabilities
}
\description{
Evalulate the probability density function under the model.
}
\examples{
model_pdf(x = 1, later_mu = 1, later_sd = 1)
model_pdf(x = 1, later_mu = 1, later_sd = 1, early_sd = 3)
}
