% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KSEA.KS_table.R
\name{KSEA.KS_table}
\alias{KSEA.KS_table}
\title{The KSEA App Analysis (K-S Dataset Only)}
\usage{
KSEA.KS_table(KSData, PX, NetworKIN, NetworKIN.cutoff)
}
\arguments{
\item{KSData}{the Kinase-Substrate dataset uploaded from the file 
prefaced with "PSP&NetworKIN_"
available from github.com/casecpb/KSEA/}

\item{PX}{the experimental data file formatted as described in the KSEA.Complete() documentation}

\item{NetworKIN}{a binary input of TRUE or FALSE, indicating whether or not to include NetworKIN predictions; 
NetworKIN = TRUE means inclusion of NetworKIN predictions}

\item{NetworKIN.cutoff}{a numeric value between 1 and infinity setting 
the minimum NetworKIN score (can be left out if NetworKIN = FALSE)}
}
\value{
creates a new data frame in R with all kinase-substrate relationships used for the KSEA calculations
}
\description{
Takes a formatted phoshoproteomics data input and returns 
just the kinase-subtrate (K-S) annotations used for KSEA calculations
}
\examples{
KSData.dataset = KSEA.KS_table(KSData, PX, NetworKIN=TRUE, NetworKIN.cutoff=3)
KSData.dataset = KSEA.KS_table(KSData, PX, NetworKIN=FALSE)


}
\references{
Casado et al. (2013) Sci Signal. 6(268):rs6

Hornbeck et al. (2015) Nucleic Acids Res. 43:D512-20

Horn et al. (2014) Nature Methods 11(6):603-4
}
