% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find.IF.JCR.R
\encoding{UTF-8}
\name{find.IF.JCR}
\alias{find.IF.JCR}
\title{find.IF.JCR Journal Citation Reports (JCR) Impact Factor}
\usage{
find.IF.JCR(journals, year, exact.match = TRUE)
}
\arguments{
\item{journals}{a \code{character vector} containing journals whose impact factor is required}

\item{year}{\code{scaler}, the year for which impact factor is required. If not mensioned, then impact factor for all year is displayed.}

\item{exact.match}{\code{logical}.}
}
\value{
impact factor of the journal(s)
}
\description{
This function gives the Impact Factor of the journal(s) provided by Journal Citation Reports (JCR) Thomson Reuters
for the year 1997 to 2019. If the output shows a NA for a journal, it means that the journal has never been in JCR list.
}
\examples{
   find.IF.JCR("ieee access")
   find.IF.JCR( "ieee access", year=2016)


}
\keyword{ImpactFactor}
\keyword{JCR}
\keyword{analytics}
\keyword{clarivate}
\keyword{package}
