% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-as.IntervalData.R
\docType{methods}
\name{as.IntervalData}
\alias{as.IntervalData}
\alias{as.IntervalData,numeric-method}
\title{Convert a real number into a degenerate interval}
\usage{
\S4method{as.IntervalData}{numeric}(object)
}
\arguments{
\item{object}{A single real number stored as a single \code{numeric} object.}
}
\value{
This function returns a degenerate interval saved as an object
of class \code{IntervalData}.
}
\description{
This function allows to coerce a real number stored as a single
\code{numeric} object to a degenerate interval formed only by this real
number saved as an \code{IntervalData} instance.
}
\details{
Single real numbers could be seen as particular cases of interval-valued
data where each interval's lower and upper bounds are equal or,
alternatively, its spread is zero.
}
\examples{
## Transform a single real-valued number into an interval
## In particular, degenerate interval {1} is defined.
i <- as.IntervalData(1); i
}
\seealso{
Other coercion function is \code{\link{as.IntervalList}()}.
}
\author{
José García-García \email{garciagarjose@uniovi.es}
}
