% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_india_unemployment.R
\name{get_india_unemployment}
\alias{get_india_unemployment}
\title{Get India's Unemployment Rate from World Bank}
\source{
World Bank Open Data API: \url{https://data.worldbank.org/indicator/SL.UEM.TOTL.ZS}
}
\usage{
get_india_unemployment()
}
\value{
A tibble with the following columns:
  \itemize{
    \item \code{indicator}: Indicator name
    \item \code{country}: Country name (India)
    \item \code{year}: Year of the data (integer)
    \item \code{value}: Unemployment rate as percentage
  }
}
\description{
Retrieves India's total unemployment rate as a percentage of the total labor force
for the years 2010 to 2022 using the World Bank Open Data API.
The indicator used is SL.UEM.TOTL.ZS.
}
\details{
This function sends a GET request to the World Bank API.
If the API request fails or returns an error status code,
the function returns NULL with an informative message.
}
\note{
Requires internet connection.
}
\examples{
\dontrun{
  unemployment_data <- get_india_unemployment()
  print(unemployment_data)
}

}
\seealso{
\code{\link[httr]{GET}}, \code{\link[jsonlite]{fromJSON}}, \code{\link[dplyr]{as_tibble}}
}
