#' IDmeasurer: A package for calculation of individual identity metrics in animal signals.
#'
#' The \code{IDmeasurer} package provides functions for calculation of univariate and
#' multivariate individual identity metrics, functions generating dataset for
#' simulation of individual identity in signals, and functions for conversions
#' between the metrics
#'
#' @section IDmeasurer functions:
#' \itemize{
#'   \item \code{calcF}
#'   \item \code{calcPIC}
#'   \item \code{calcHS}
#'   \item \code{calcDS}
#'   \item \code{calcMI}
#'   \item \code{calcHM}
#'   \item \code{GenerateUnivariate}
#'   \item \code{GenerateMultivariate}
#'   \item \code{convertHStoDS}
#'   \item \code{convertDStoHS}
#' }
#'
#' Please, use \code{vignette('idmeasurer-workflow-examples')} to learn more about the functions.
#'
#' @docType package
#' @name IDmeasurer
NULL
