% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeSAIR.R
\name{computeSAIR}
\alias{computeSAIR}
\title{computeSAIR}
\usage{
computeSAIR(hM, X = NULL)
}
\arguments{
\item{hM}{a fitted \code{Hmsc} model object}

\item{X}{a design matrix to be used in the computations (as defaul hM$X)}
}
\value{
returns the posterior distribution of the parameters mu.X2,V.XX,mu.Omega2,V.OmegaOmega,mu.tot,V.tot,s
described Ovaskainen and Abrego (manuscript):
Measuring niche overlap with joint species distribution models: shared and idiosyncratic responses of the species to measured and latent predictors
}
\description{
Computes the shared and idiosyncratic responses to measured and latent predictors
}
\details{
The shared and idiosyncratic responses are computed only for models without traits.
}
\examples{
# Simulate a small dataset, fit Hmsc model to it, compute SAIR, and show posterior means 

nc = 2
ns = 5
ny = 10
mu = rnorm(n = nc)
X = matrix(rnorm(n=nc*ny),nrow=ny)
X[,1] = 1
eps = matrix(rnorm(nc*ns),nrow=nc)
L = matrix(rep(X\%*\%mu,ns),nrow=ny)  + X\%*\%eps
Y = pnorm(L)
m = Hmsc(Y = Y, XData = data.frame(env = X[,2]), distr = "probit")
m = sampleMcmc(m,samples=100,transient=50,verbose = 0)
SI = computeSAIR(m)
colMeans(SI)

}
