% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_differential_chiclet.R
\name{plot_differential_chiclet}
\alias{plot_differential_chiclet}
\title{Chiclet differential deuterium uptake plot}
\usage{
plot_differential_chiclet(
  diff_uptake_dat = NULL,
  diff_p_uptake_dat = NULL,
  theoretical = FALSE,
  fractional = FALSE,
  show_houde_interval = FALSE,
  show_tstud_confidence = FALSE,
  confidence_level = 0.98,
  show_uncertainty = FALSE,
  interactive = getOption("hadex_use_interactive_plots")
)
}
\arguments{
\item{diff_uptake_dat}{data produced by \code{\link{calculate_diff_uptake}} or
\code{\link{create_diff_uptake_dataset}} function}

\item{diff_p_uptake_dat}{differential uptake data 
alongside the P-value as calculated by 
\code{\link{create_p_diff_uptake_dataset}}}

\item{theoretical}{\code{logical}, determines if values are theoretical}

\item{fractional}{\code{logical}, determines if values are fractional}

\item{show_houde_interval}{\code{logical}, determines if houde interval is shown}

\item{show_tstud_confidence}{\code{logical}, determines if t-Student test validity 
is shown}

\item{confidence_level}{confidence level for the test, from range [0, 1]
Important if selected show_confidence_limit}

\item{show_uncertainty}{\code{logical}, determines if the
uncertainty is shown}

\item{interactive}{\code{logical}, whether plot should have an interactive 
layer created with with ggiraph, which would add tooltips to the plot in an
interactive display (HTML/Markdown documents or shiny app).}
}
\value{
a [ggplot2::ggplot()] object.
}
\description{
Chiclet plot of differential deuterium uptake values 
between two biological states in time.
}
\details{
Function \code{\link{plot_differential_chiclet}} generates
chiclet differential plot based on provided data and parameters.
On X-axis there is a peptide ID. On Y-axis are time points
of measurement. Each tile for a peptide in time has a color value
representing the deuterium uptake difference between chosen states,
in a form based on provided criteria (e.q. fractional). Each tile has
a plus sign, which size represent the uncertainty of measurement for
chosen value.
}
\examples{
diff_uptake_dat <- create_diff_uptake_dataset(alpha_dat)
plot_differential_chiclet(diff_uptake_dat)
plot_differential_chiclet(diff_uptake_dat, show_houde_interval = TRUE)

diff_p_uptake_dat <- create_p_diff_uptake_dataset(alpha_dat)
plot_differential_chiclet(diff_p_uptake_dat = diff_p_uptake_dat, 
                          show_tstud_confidence = TRUE)
plot_differential_chiclet(diff_p_uptake_dat = diff_p_uptake_dat, 
                          show_tstud_confidence = TRUE, show_houde_interval = TRUE) 

}
\seealso{
\code{\link{create_diff_uptake_dataset}}
\code{\link{calculate_diff_uptake}}
}
