% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hdx_data_class.R
\name{new_hdx_data}
\alias{new_hdx_data}
\title{Constructor of hdx_data class}
\usage{
new_hdx_data(dat, source, has_modification, n_rep)
}
\arguments{
\item{dat}{\code{\link{data.frame}}, read from the datafile.}

\item{source}{\code{\link{character}}, the source of the datafile.}

\item{has_modification}{\code{\link{logical}}, indicator if there are 
modified peptides in the datafile.}
}
\value{
\code{\link{hdx_data}} object.
}
\description{
Class hdx_data is the base of any calculation done in HaDeX. 
It structuralizes the data from the data file read by the \code{\link{read_hdx}} 
function. The object preserves the information of the data file origin - for now,
the function accepts datafiles from DynamX2.0, DynamX3.0 and HDeXaminer. The data 
from the datafile is checked and put in one format suitable for the package
workflow, regardless of its origin. 

The structure is as follows:
- Protein, character.
- Start, integer.
- End, integer.
- Sequence, character.
- MaxUptake, numeric.
- MHP, numeric.
- State, character.
- Exposure, numeric.
- File, character.
- z, integer.
- Inten, numeric. 
- Center, numeric.

The hdx_data class inherits from data.frame class, so the structure is preserved.
The hdx_data object has two additional attributes:
- source, character. Indicates the source of the datafile.
- has_modification, logical. Indicates if the datafile has data from modified
peptides.
}
\keyword{internal}
