% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.checkwise.R
\name{print.checkwise}
\alias{print.checkwise}
\title{A Method to Print the Accuracy of Outlier Classification Results}
\usage{
\method{print}{checkwise}(x, confusion = FALSE, ...)
}
\arguments{
\item{x}{An S3 object of the class \code{checkwise}, typically computed with the function \code{class_check}.}

\item{confusion}{A logical value, which is \code{FALSE} by default. If \code{TRUE}, the confusion matrix is printed after showing all accuracy metrics.}

\item{...}{Additional arguments to pass to the function \code{cat}.}
}
\value{
An S3 class named \code{checkwise} with the confusion matrix, and other accuracy metrics appended as attribues.

\code{attr(, "overall")} A numeric value between zero and one with the overall accuracy.

\code{attr(, "recall")} A numeric vector of values between zero and one with the recall index for regular and outlier cells.

\code{attr(, "precision")} A numeric vector of values between zero and one with the precision index for regular and outlier cells.

\code{attr(, "f1-score")} A numeric vector of values between zero and one with the F1-scores for regular and outlier cells.
}
\description{
The function prints the confusion matrix and accuracy results previously computed with the function \code{class_check}.
}
\details{
The function computes the confusion matrix using the function \code{table}. True positive and false negative are successively evaluated to compute overall accuracy, recall, precision, and F1-scores.
}
\examples{
\dontrun{
# Load the package
library(HRTnomaly)
set.seed(2025L)
# Load the 'toy' data
data(toy)
# Detect cellwise outliers using Bayesian Analysis
res <- cellwise(toy[sample.int(100), ], 0.5, 10L)
class_check(res$outlier, res$anomaly_flag != "")
}
}
\author{
Luca Sartore \email{drwolf85@gmail.com}
}
\keyword{distribution}
\keyword{outliers}
\keyword{probability}
