% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sd_ave_diff_pv_tp.R
\name{pv_timepoint}
\alias{pv_timepoint}
\title{Calculation of pvalue between first protein state and any other state from all_states file}
\usage{
pv_timepoint(df, replicates = 3)
}
\arguments{
\item{df}{output from functions output_tp or output_tp_proc.}

\item{replicates}{number of replicates used. Default is set to replicates=3}
}
\value{
Data.frame with p-values
}
\description{
Compares means of sets of uptake data and return dataframe with pvalues.
Welch t.test is used for analysis.
Sets are compared to the first state in the input file.
If other order of the sets is required use
Default for the number of replicates is 3.
}
\examples{
file_nm<-system.file("extdata", "All_results_table.csv", package = "HDXBoxeR")
a<- output_tp(file_nm)
pv<-pv_timepoint(df=a) ##if number of replicates is equal 3
# pv1<-pv_timepoint(df=a, replicates=4) ##if number of replicates is equal 4
#b<-output_tp_states(file_nm, states=c("State4", "State2", "State3" ))
#pv_states<-pv_timepoint(df=b) ### here means of State4, will be compared to State2 and State4
}
