% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel_functions.R
\name{compute_gram_matrix}
\alias{compute_gram_matrix}
\title{Gram Matrix Computation}
\usage{
compute_gram_matrix(X, kernel_type, params = c())
}
\arguments{
\item{X}{The design matrix with $n$ rows (one for each subject) and $p$ columns 
(one for each measurement on the subject). This is the design matrix you wish 
to search for a more optimal design.}

\item{kernel_type}{One of the following: "vanilla", "rbf", "poly", "tanh", "bessel", "laplace", 
"anova" or "spline".}

\item{params}{A vector of numeric parameters. Each \code{kernel_type} has different numbers of
parameters required. For more information see documentation for the \code{kernlab} library.}
}
\value{
The \code{n x n} gram matrix for the given kernel on the given data.
}
\description{
Computes the Gram Matrix for a user-specified kernel using the library \code{kernlab}. Note that 
this function automatically standardizes the columns of the data entered.
}
\examples{
\dontrun{
set.seed(1)
X = matrix(rnorm(12), nrow = 6)
K = compute_gram_matrix(X, kernel_type = "rbf", params = 0.5)
dim(K)
}
}
\author{
Adam Kapelner
}
