% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gendata.R
\name{gendata}
\alias{gendata}
\title{Generate the grouped data}
\usage{
gendata(
  seed = 1,
  T = 50,
  N = rep(30, 5),
  r0 = 2,
  r = rep(2, 5),
  Phi_G = 0.5,
  Phi_F = 0.5,
  Phi_e = 0.5,
  W_F = 0.5,
  beta = 0.2,
  kappa = 1,
  case = 1
)
}
\arguments{
\item{seed}{The seed used in \code{set.seed}. Default is 1.}

\item{T}{The number of time points. Default is 50.}

\item{N}{A vector representing the number of variables in each group. Default is \code{rep(30, 5)}.}

\item{r0}{The number of global factors. Default is 2.}

\item{r}{A vector representing the number of the local factors. Notice, the length of \eqn{r} is the same as the length of \eqn{N} (which implies the number of groups \eqn{M}). Default is \code{rep(2, 5)}.}

\item{Phi_G}{Hyperparameter of the global factors (AR(1) coefficient). Default is 0.5. The value should be between 0 and 1.}

\item{Phi_F}{Hyperparameter of the local factors (AR(1) coefficient). Default is 0.5. The value should be between 0 and 1.}

\item{Phi_e}{Hyperparameter of the errors. Default is 0.5. The value should be between 0 and 1.}

\item{W_F}{Hyperparameter of the correlation of local factors. Only applicable when \code{case = 3}. The value should be between 0 and 1. Default is 0.5.}

\item{beta}{Hyperparameter of the errors (spatial correlation). Default is 0.2.}

\item{kappa}{Hyperparameter of signal to noise ratio. Default is 1.}

\item{case}{The case of the data-generating process. Default is 1. It can also be 2 or 3.}
}
\value{
An object of class \code{"GFD"} containing:
\item{y}{A list of the generated data matrices.}
\item{G}{The global factors matrix.}
\item{F}{A list of the local factors.}
\item{loading_G}{A list of the global factor loadings.}
\item{loading_F}{A list of the local factor loadings.}
\item{T}{The number of time points.}
\item{N}{The vector of variables per group.}
\item{M}{The number of groups.}
\item{r0}{The number of global factors.}
\item{r}{The vector of local factors.}
\item{case}{The generation case used.}
}
\description{
Generate the grouped data for simulation studies.
}
\examples{
dat <- gendata()
print(dat)
}
\references{
Aggregated Projection Method: A New Approach for Group Factor Model. Jiaqi Hu, Ting Li, Xueqin Wang (2025). Journal of the American Statistical Association, doi:10.1080/01621459.2025.2491154
}
