% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GCD.R
\name{GCD}
\alias{GCD}
\title{Calculates the maximum pairwise great circle distance from a set of decimal degree coordinates}
\usage{
GCD(longs, lats)
}
\arguments{
\item{longs}{- Longitudinal coordinates of occurrences in decimal degrees}

\item{lats}{- Latitudinal coordinates of occurrences in decimal degrees}
}
\value{
Returns the maximum great circle distance in kilometers
}
\description{
Calculates the maximum pairwise great circle distance from a set of decimal degree coordinates
}
\details{
Because this function does not account for the possibility that a taxa may wrap around more than half the Earth the maximum value is half the circumference of the Earth, approximately 20,038 kilometers.
}
\note{
The great circle distance can be extracted from the result of a minium spanning tree calcualation MSTDist() if available to avoid redundant calculations
}
\examples{
longs<-c(34,156,-78)
lats<-c(45,12,9)
GCD(longs,lats)
}
