% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GRAB_Region.R
\name{GRAB.Region}
\alias{GRAB.Region}
\title{Perform region-based association tests}
\usage{
GRAB.Region(
  objNull,
  GenoFile,
  OutputFile,
  GenoFileIndex = NULL,
  OutputFileIndex = NULL,
  GroupFile,
  SparseGRMFile = NULL,
  MaxMAFVec = "0.01,0.001,0.0005",
  annoVec = "lof,lof:missense,lof:missense:synonymous",
  control = NULL
)
}
\arguments{
\item{objNull}{(S3 object) Null model object from \code{\link{GRAB.NullModel}}.
Currently supports POLMM_NULL_Model.}

\item{GenoFile}{(character) Path to genotype file (PLINK or BGEN format). See
\code{\link{GRAB.ReadGeno}} for details.}

\item{OutputFile}{(character) Path for saving region-based association results.}

\item{GenoFileIndex}{(character or NULL) Index files for the genotype file. If
\code{NULL} (default), uses same prefix as \code{GenoFile}. See
\code{\link{GRAB.ReadGeno}} for details.}

\item{OutputFileIndex}{(character or NULL) Path for progress tracking file. If
\code{NULL} (default), uses \code{paste0(OutputFile, ".index")}.}

\item{GroupFile}{(character) Path to region definition file specifying region-marker
mappings and annotation information. Tab-separated format with 2-3 columns per region.}

\item{SparseGRMFile}{(character or NULL) Path to sparse GRM file (optional).}

\item{MaxMAFVec}{(character) Comma-separated MAF cutoffs for including variants in
analysis (default: "0.01,0.001,0.0005").}

\item{annoVec}{(character) Comma-separated annotation groups for analysis
(default: "lof,lof:missense,lof:missense:synonymous").}

\item{control}{(list or NULL) List of the following parameters:
\itemize{
\item \code{impute_method} (character): Method for imputing missing genotypes:
"mean", "minor", or "drop". Default: "minor".
\item \code{missing_cutoff} (numeric): Exclude markers with missing rate > this value.
Range: 0 to 0.5. Default: 0.15.
\item \code{min_mac_region} (numeric): Minimum MAC threshold; markers with
MAC < this value are treated as ultra-rare variants. Default: 5.
\item \code{max_markers_region} (integer): Maximum number of markers allowed per region. Default: 100.
\item \code{r.corr} (numeric vector): Rho parameters for SKAT-O test. Range: 0 to 1.
Default: c(0, 0.1^2, 0.2^2, 0.3^2, 0.4^2, 0.5^2, 0.5, 1).
\item \code{weights.beta} (numeric vector): Beta distribution parameters for variant weights (length 2).
Default: c(1, 25).
\item \code{omp_num_threads} (integer): Number of OpenMP threads for parallel computation.
Default: data.table::getDTthreads().
\item \code{min_nMarker} (integer): Minimum number of markers required for region analysis. Default: 3.
\item \code{SPA_Cutoff} (numeric): Z-score cutoff for saddlepoint approximation. When the absolute
value of the test statistic exceeds this cutoff, SPA is used to calculate more accurate p-values. Default: 2.
}}
}
\value{
The function returns \code{NULL} invisibly. Results are saved to four files:
\enumerate{
\item \code{OutputFile}: Region-based test results (SKAT-O, SKAT, Burden p-values).
\item \code{paste0(OutputFile, ".markerInfo")}: Marker-level results for rare variants
(MAC >= \code{min_mac_region}) included in region tests.
\item \code{paste0(OutputFile, ".otherMarkerInfo")}: Information for excluded markers
(ultra-rare variants or failed QC).
\item \code{paste0(OutputFile, ".infoBurdenNoWeight")}: Summary statistics for burden
tests without weights.
}

For method-specific examples and output columns and format, see:
\itemize{
\item POLMM method: \code{\link{GRAB.POLMM.Region}}
}
}
\description{
Tests for association between phenotypes and genomic regions containing multiple
genetic variants, primarily low-frequency and rare variants.
}
