% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Util.R
\name{CCT}
\alias{CCT}
\title{Cauchy Combination Test for p-value aggregation}
\usage{
CCT(pvals, weights = NULL)
}
\arguments{
\item{pvals}{Numeric vector of p-values to combine (each between 0 and 1).
P-values equal to 1 are automatically adjusted to 0.999. P-values equal
to 0 will cause an error.}

\item{weights}{Numeric vector of non-negative weights for each p-value.
If NULL, equal weights are used. Must have same length as pvals.}
}
\value{
Single aggregated p-value combining all input p-values.
}
\description{
Combines multiple p-values using the Cauchy distribution method, which provides
analytical p-value calculation under arbitrary dependency structures.
}
\details{
The Cauchy Combination Test (CCT) transforms p-values using the inverse Cauchy
distribution and combines them with specified weights. This method is particularly
powerful because it:
\itemize{
\item Works under arbitrary dependency structures
\item Provides exact analytical p-values (no simulation needed)
\item Maintains good power properties across different scenarios
}

\strong{Special Cases:}
\itemize{
\item If any p-value equals 0, returns 0 immediately
\item P-values equal to 1 are adjusted to 0.999 with a warning
\item Very small p-values (< 1e-16) receive special numerical treatment
}
}
\examples{
# Basic usage with equal weights
pvalues <- c(0.02, 0.0004, 0.2, 0.1, 0.8)
CCT(pvals = pvalues)

# Usage with custom weights
weights <- c(2, 3, 1, 1, 1)
CCT(pvals = pvalues, weights = weights)

}
\references{
Liu, Y., & Xie, J. (2020). Cauchy combination test: a powerful test
with analytic p-value calculation under arbitrary dependency structures.
\emph{Journal of the American Statistical Association}, 115(529), 393-402.
\doi{10.1080/01621459.2018.1554485}
}
