getInit <-
function(x, k, method, run_number = 10, max_iter = 3, tol = 1e-6 , burn_in= 3){
  
  result <- switch(method,
                   "Random" = param_random(x, k),
                   "emEM" =   param_emEM(x, k),
                   "emAEM" = param_emaEM(x, k),
                   "hierarchical average" = param_hier_aver(x,k),
                   "hierarchical ward" = param_hier_ward(x, k),
                   "kmeans" = param_kmean(x, k),
                   "mclust" = param_mclust(x, k),
                   "cem" = param_CEM(x,k),
                   "sem" =  rerun(function()param_SEM(x,k)),
                   stop("Invalid method. Choose from 'Random', 'emEM', 'emAEM' or 
                        'hierarchical average', 'hierarchical ward', 'kmeans', 
                         'mclust', 'cem', or 'sem'."))
  
  return(result)
  
}
