% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmgceclassfunctions.R
\name{nobs.lmgce}
\alias{nobs.lmgce}
\title{Extract the Number of Observations from a \code{\link{lmgce}} model fit}
\usage{
\method{nobs}{lmgce}(object, ...)
}
\arguments{
\item{object}{Fitted \code{\link{lmgce}} model object.}

\item{...}{additional arguments.}
}
\value{
An integer scalar representing the number of observations (rows) used
 in fitting the \code{\link{lmgce}} model object.
}
\description{
Extract the number of ‘observations’ from a \code{\link{lmgce}} model fit.
}
\examples{
\donttest{
res_gce_package <-
  lmgce(y ~ .,
        data = dataGCE,
        boot.B = 50,
        seed = 230676)
}

nobs(res_gce_package)

}
\author{
Jorge Cabral, \email{jorgecabral@ua.pt}
}
