% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power.R
\name{power.signtest}
\alias{power.signtest}
\title{Compute power of the sign test}
\usage{
power.signtest(n, alpha, p)
}
\arguments{
\item{n}{sample size (scalar)}

\item{alpha}{p-value threshold (scalar)}

\item{p}{Pr(X>0), as in Noether (JASA 1987)}
}
\value{
Vector of power estimates for two-sided tests
}
\description{
Use the Noether (1987) formula to compute the power of the sign test, which is based on asymptotic normal approximation.
}
\details{
In most applications, the null effect size will be designated by p = 0.5
}
\examples{
p = rep(c(0.8,0.5),c(100,900));
res = power.signtest(n = 50, alpha = 0.05, p = p)
}
\references{
Noether, Gottfried E (1987) Sample size determination for some common nonparametric tests. Journal of the American Statistical Association, 82:645-647.
}
