
c_byrow <- \(x) x |> t() |> c()

threshold_support <- \(mu, tol.0) {
    mu[mu < tol.0] <- 0
    if (is.null(dim(mu))) {
        mu / sum(mu)
    } else {
        sweep(mu, 1, rowSums(mu), "/")
    }
}

group_idx <- \(group.sizes) {
    m <- c(0, cumsum(group.sizes))
    lapply(seq_along(group.sizes), \(i) seq.int(m[i] + 1, m[i + 1]))
}

##

as_rowmat <- \(x) {
    if (is.list(x)) {
        stopifnot(length(x) > 0)
        do.call(rbind, x)
    } else if (is.null(dim(x))) {
        matrix(x, ncol = length(x))
    } else {
        x
    }
}

as_rowmat0 <- \(x, N) {
    if (is.list(x) && length(x) == 0) {
        matrix(0, 0, N)
    } else {
        res <- as_rowmat(x)
        stopifnot(is_num_mat(res), ncol(res) == N)
        res
    }
}

## checking

is_scalar <- \(x) is.atomic(x) && length(x) == 1

is_num_scalar <- \(x) is_scalar(x) && is.numeric(x)

is_nonneg_scalar <- \(x) is_num_scalar(x) && (x >= 0)

is_wholenumber <- \(x, tol = .Machine$double.eps^0.5) abs(x - round(x)) < tol

is_nat_scalar <- \(x) is_num_scalar(x) && is_wholenumber(x) && (x > 0)

is_log_scalar <- \(x) is_scalar(x) && is.logical(x)

is_str_scalar <- \(x) is_scalar(x) && is.character(x)

is_num_mat <- \(x) {
    is.matrix(x) && is.numeric(x) && all(is.finite(x))
}

is_num_vec <- \(x) {
    is.vector(x, "numeric")
}

is_sample_vec <- \(x) {
    is_num_vec(x) && all(is_wholenumber(x)) && all(x >= 0)
}

is_prob_vec <- \(x, strict = FALSE) {
    is_num_vec(x) && ((strict && all(x > 0)) || (!strict && all(x >= 0))) && isTRUE(all.equal(sum(x), 1, check.attributes = FALSE))
}

is_idx <- \(x) is_wholenumber(x) & (x >= 1)
id_idx_ll <- \(x) sapply(x, is_idx)

check_samplemat <- \(samples) {
    stopifnot(apply(samples, 1, is_sample_vec))
}

check_mu <- \(mu) {
    stopifnot(apply(mu, 1, is_prob_vec))
}

check_cost_mat <- \(costm, N, is.metric) {
    if (!missing(is.metric)) {
        stopifnot(
            is.list(is.metric),
            is_log_scalar(is.metric$semi.metric),
            is_log_scalar(is.metric$metric),
            is.metric$semi.metric
        )
    }
    stopifnot(
        is_num_mat(costm),
        dim(costm) == c(N, N)
    )
}

check_w <- \(w, K) {
    stopifnot(
        is_prob_vec(w, TRUE),
        length(w) == K
    )
}

check_delta <- \(delta, K) {
    stopifnot(
        is_prob_vec(delta, TRUE),
        length(delta) == K
    )
}

check_n <- \(n, K) {
    stopifnot(
        is_num_vec(n),
        is_wholenumber(n),
        n > 0,
        length(n) == K
    )
}

check_lp_solver <- \(solver) {
    stopifnot(is_solver_control(solver))
}

check_numsim <- \(num.sim) {
    stopifnot(is_nat_scalar(num.sim))
}

##

print_info_base <- \(base, verbose) {
    stopifnot(is_log_scalar(verbose))
    if (verbose) {
        \(x, ...) cat("[ ", format(Sys.time(), usetz = TRUE), " | ", base, " ] ", sprintf(x, ...), "\n", sep = "")
    } else {
        \(...) invisible()
    }
}

catf <- \(fmt, ...) cat(sprintf(fmt, ...))
