% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.mjmcmc_parallel}
\alias{summary.mjmcmc_parallel}
\title{Function to Print a Quick Summary of the Results}
\usage{
\method{summary}{mjmcmc_parallel}(
  object,
  tol = 1e-04,
  labels = FALSE,
  effects = NULL,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{object}{The results to use}

\item{tol}{The tolerance to use as a threshold when reporting the results.}

\item{labels}{Should the covariates be named, or just referred to as their place in the data.frame.}

\item{effects}{Quantiles for posterior modes of the effects across models to be reported, if either effects are NULL or if labels are NULL, no effects are reported.}

\item{verbose}{If the summary should be printed to the console or just returned, defaults to TRUE}

\item{...}{Not used.}
}
\value{
A data frame containing the following columns:
\item{feats.strings}{Character representation of the covariates ordered by marginal probabilities.}
\item{marg.probs}{Marginal probabilities corresponding to the ordered feature strings.}
}
\description{
Function to Print a Quick Summary of the Results
}
\examples{
result <- mjmcmc.parallel(runs = 1, 
cores = 1,  
y = matrix(rnorm(100), 100),
x = matrix(rnorm(600), 100), 
loglik.pi = gaussian.loglik)
summary(result)

}
