% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WhyperCI_N.R
\name{WhyperCI_N_lower}
\alias{WhyperCI_N_lower}
\title{An Admissible Exact One-sided Lower Interval for the Population Number of
Hypergeometric Distribution}
\usage{
WhyperCI_N_lower(x, n, M, conf.level, details = FALSE)
}
\arguments{
\item{x}{integer representing the number of white balls we observed when
drawn without replacement from an urn which contains both black and white
balls.}

\item{n}{the number we drawn.}

\item{M}{the number of the white balls.}

\item{conf.level}{the confidence level of confidence interval.}

\item{details}{TRUE/FALSE, can be abbreviate. Default is FALSE. If choose
TRUE, the confidence intervals for the whole sample space will be returned.}
}
\value{
a list which contains the confidence interval.
}
\description{
The 1-alpha Clopper-Pearson type lower interval for the
population number of hypergeometric distribution.
}
\examples{
WhyperCI_N_lower(0,50,800,0.95,details=TRUE)
WhyperCI_N_lower(0,50,800,0.95)
}
\references{
Konijn, H. S. (1973). Statistical Theory of Sample Survey Design
and Analysis, Amsterdam: North-Holland.
}
