% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepapre_regression_table.R
\name{prepare_regression_table}
\alias{prepare_regression_table}
\title{Prepares a Regression Table}
\usage{
prepare_regression_table(
  df,
  dvs,
  idvs,
  feffects = rep("", length(dvs)),
  clusters = rep("", length(dvs)),
  models = rep("auto", length(dvs)),
  byvar = "",
  format = "html"
)
}
\arguments{
\item{df}{Data frame containing the data to estimate the models on.}

\item{dvs}{A character vector containing the variable names for the dependent variable(s).}

\item{idvs}{A character vector or a a list of character vectors containing the variable names of the independent variables.}

\item{feffects}{A character vector or a a list of character vectors containing the variable names of the fixed effects.}

\item{clusters}{A character vector or a a list of character vectors containing the variable names of the cluster variables.}

\item{models}{A character vector indicating the model types to be estimated ('ols', 'logit', or 'auto')}

\item{byvar}{A factorial variable to estimate the model on (only possible if only one model is being estimated).}

\item{format}{A character scalar that is passed on \code{\link[stargazer]{stargazer}} as \code{type} to determine the presentation
format ("html", "text", or "latex").}
}
\value{
A list containing two items
\describe{
 \item{"models"}{A list containing the model results and by values if appropriate}
 \item{"table"}{The output of \code{\link[stargazer]{stargazer}} containing the table}
}
}
\description{
Builds a regression table based on a set of user-specified models or a single model and a partitioning variable.
}
\details{
This is a wrapper function calling the stargazer package. For numeric
  dependent variables the models are estimated using \code{\link[stats]{lm}}
  for models without and \code{\link[plm]{plm}} for models with fixed
  effects. Binary dependent variable models are estimated using
  \code{\link[stats]{glm}} (with \code{family = binomial(link="logit")}).
  You can override this behavior by specifying the model with the
  \code{models} parameter. Multinomial logit models are not supported.
  Clustered standard errors are estimated using \code{plm}'s robust
  covariance matrix estimators for OLS and
  \code{\link[multiwayvcov]{cluster.vcov}} for logit models.
  Only up to two dimensions are supported for fixed effects and standard
  error clusters need to be also present as fixed effects.
  If run with \code{byvar}, only levels that have more observations than
  coefficients are estimated.
}
\examples{
df <- data.frame(year = as.factor(floor(stats::time(datasets::EuStockMarkets))),
                 datasets::EuStockMarkets)
dvs = c("DAX", "SMI", "CAC", "FTSE")
idvs = list(c("SMI", "CAC", "FTSE"),
            c("DAX", "CAC", "FTSE"),
            c("SMI", "DAX", "FTSE"),
            c("SMI", "CAC", "DAX"))
feffects = list("year", "year", "year", "year")
clusters = list("year", "year", "year", "year")
t <- prepare_regression_table(df, dvs, idvs, feffects, clusters, format = "text")
t$table
t <- prepare_regression_table(df, "DAX", c("SMI", "CAC", "FTSE"), byvar="year", format = "text")
print(t$table)
}
