% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FH_test.R
\name{FH_test}
\alias{FH_test}
\title{Fleming-Harrington weighted log-rank tests}
\usage{
FH_test(survival, delta, trt, rho, gamma, test = c("Futility"))
}
\arguments{
\item{survival}{Time to event or censoring.}

\item{delta}{Event indicators.}

\item{trt}{Treatment assignment indicator with 1 denoting the treated group, and 0 denoting the placebo group.}

\item{rho}{First power parameter for the Fleming-Harrington weight which weighs on the early departures: \eqn{S(t^-)^\rho(1-S(t^-))^\gamma}.}

\item{gamma}{Second power parameter for the Fleming-Harrington weight which weighs on the late departures: \eqn{S(t^-)^\rho(1-S(t^-))^\gamma}.}

\item{test}{a character denotes the test type, include "Superiority","Futility","Two-sided"}
}
\value{
A list 3 different components
\item{O1}{Observed number of weighted events (with a multiplication of corresponding weights) in the treatment arm.}
\item{E1 }{Expected number of weighted events (with a multiplication of corresponding weights) in the treatment arm.}
\item{Z}{Weighted log-rank test statistic.}
\item{pvalue}{Weighted log-rank test statistic pvalue}
}
\description{
Calculating the Fleming-Harrington weighted log-rank tests
}
\examples{
n <- 500
event <- runif(n,1, 5)
osc<-1*(event<=4)
os <- pmin(event,4)
trt<-c(rep(0,n/2),rep(1,n/2))
FH_test(os,osc,trt,rho=1,gamma=0)

}
