% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ml_data}
\alias{ml_data}
\title{Machine Learning Data for Disease Risk Prediction}
\format{
A data frame with 100 rows and 5 columns:
\describe{
  \item{outcome}{Numeric, binary disease status (0 = healthy, 1 = diseased).}
  \item{age}{Numeric, patient age (years).}
  \item{exposure}{Numeric, exposure level (0 to 1, e.g., environmental risk).}
  \item{genetic_risk}{Numeric, genetic risk score (0 to 1).}
  \item{region}{Character, region name (e.g., North, South, East, West).}
}
}
\source{
Simulated data for demonstration purposes.
}
\usage{
ml_data
}
\description{
A dataset containing simulated patient data for predicting disease risk, suitable for logistic regression, clustering, Random Forest, and SVM.
}
\examples{
data("ml_data")
ml_data$outcome <- as.factor(ml_data$outcome)
epi_model(ml_data, formula = outcome ~ age + exposure + genetic_risk, type = "logistic")
epi_model(ml_data, formula = outcome ~ age + exposure + genetic_risk, type = "rf")
epi_visualize(ml_data, x = "age", y = "outcome", type = "scatter")
}
\keyword{datasets}
