% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bsts_model.R
\name{bsts_model}
\alias{bsts_model}
\title{Bayesian Structural Time Series Model}
\usage{
bsts_model(
  data_path,
  circ_vars,
  prod_vars,
  max_lag = 6,
  lfo_init_frac = 0.8,
  lfo_h = 6,
  lfo_step = 6,
  niter = 2000,
  burn = 500,
  seed = 123,
  seasonality = NULL,
  support_min = 0.6,
  folds_min = 5,
  sup_hi = 0.7,
  sup_lo = 0.6,
  out_dir = NULL
)
}
\arguments{
\item{data_path}{Path to Excel file containing the data}

\item{circ_vars}{Character vector of circulation variable names}

\item{prod_vars}{Character vector of production variable names}

\item{max_lag}{Maximum number of lags for independent variables (default: 6)}

\item{lfo_init_frac}{Initial fraction for LFO (default: 0.8)}

\item{lfo_h}{Horizon for LFO (default: 6)}

\item{lfo_step}{Step size for LFO (default: 6)}

\item{niter}{Number of MCMC iterations (default: 2000)}

\item{burn}{Number of burn-in iterations (default: 500)}

\item{seed}{Random seed (default: 123)}

\item{seasonality}{Seasonality parameter (NULL for none, 12 for monthly)}

\item{support_min}{Minimum support threshold (default: 0.6)}

\item{folds_min}{Minimum number of folds required (default: 5)}

\item{sup_hi}{High support threshold (default: 0.7)}

\item{sup_lo}{Low support threshold (default: 0.6)}

\item{out_dir}{Output directory for results (default: "output_bsts")}
}
\value{
A list containing:
\item{rank_ss_all}{Full results for all pairs}
\item{winners_ss_070}{Pairs with support >= 0.70}
\item{winners_ss_060}{Pairs with support >= 0.60}
\item{summaries_ss}{Summary statistics}
}
\description{
Implements Bayesian Structural Time Series models with Leave-Future-Out validation
for assessing causal relationships between economic variables with temporal stability.
}
\details{
This function implements Bayesian Structural Time Series models for assessing
causal relationships between economic variables. It uses Leave-Future-Out
cross-validation with tuning between Local Level and Local Linear Trend
specifications. The methodology is described in detail in the methodological
document "DETALLES METODOLOGICOS SPACESTATE MODEL.docx".
}
\examples{
\dontrun{
# Example usage
result <- bsts_model(
  data_path = file.path(tempdir(), "data.xlsx"),
  circ_vars = c("TC_SPOT_CAN_US", "TC_SPOT_US_CAN", "TC_SPOT_US_REMB",
                "IPC", "TdI_LdelT", "TasaDescuento"),
  prod_vars = c("ValorExportaciones", "Real_Net_Profit", 
                "RealSocialConsumptionPerWorker2017", "RealWage_PPP2017",
                "CapitalStock_PPP2017", "LaborProductivity_PPP2017", 
                "InvestmentPerWorker_PPP2017")
)
}

}
