% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EQRN_seq_network_structures.R
\name{QRNN_RNN_net}
\alias{QRNN_RNN_net}
\title{Recurrent quantile regression neural network module}
\usage{
QRNN_RNN_net(
  type = c("lstm", "gru"),
  nb_input_features,
  hidden_size,
  num_layers = 1,
  dropout = 0
)
}
\arguments{
\item{type}{the type of recurrent architecture, can be one of \code{"lstm"} (default) or \code{"gru"},}

\item{nb_input_features}{the input size (i.e. the number of features),}

\item{hidden_size}{the dimension of the hidden latent state variables in the recurrent network,}

\item{num_layers}{the number of recurrent layers,}

\item{dropout}{probability parameter for dropout before each hidden layer for regularization during training.}
}
\value{
The specified recurrent QRN as a \code{\link[torch:nn_module]{torch::nn_module}}.
}
\description{
A recurrent neural network as a \code{\link[torch:nn_module]{torch::nn_module}},
designed for quantile regression.
}
\details{
The constructor allows specifying:
\describe{
\item{type}{the type of recurrent architecture, can be one of \code{"lstm"} (default) or \code{"gru"},}
\item{nb_input_features}{the input size (i.e. the number of features),}
\item{hidden_size}{the dimension of the hidden latent state variables in the recurrent network,}
\item{num_layers}{the number of recurrent layers,}
\item{dropout}{probability parameter for dropout before each hidden layer for regularization during training.}
}
}
