% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/channels.R
\name{add_colors}
\alias{add_colors}
\title{Add color scheme to a \code{ggm} object}
\usage{
add_colors(object, palette, mode)
}
\arguments{
\item{object}{A \code{ggm} object}

\item{palette}{A \code{character} choice from the below options that describe the
color choices to be used for plotting. If set to the default, which is
\code{NULL}, no changes to the colors for individual channels will be performed.
If a positive choice is made, then the background \strong{mode} argument will be
set to \emph{dark} as the default, unless otherwise specified. \emph{WARNING}: This is
an experimental argument, and may be moved in future version.
\itemize{
\item \strong{NULL}: no changes to the colors will be made. DEFAULT.
\item \strong{material}: a colorscheme based off of the \href{https://m3.material.io/styles/color/system/how-the-system-works}{Material Design} color scheme
}}

\item{mode}{A \code{character} string from \code{c("dark", "light")} to describe the
base/background color settings to be used. If there are preset channel
colors that were exported in the \code{egm} object, these colors will be used
for the individual channels. If \strong{palette} is specified, then the \emph{dark}
option will be set automatically (a palette choice cannot be made without
understanding the background to plate it across). \emph{WARNING}: This is an
experimental argument, and may be moved in future version.
\itemize{
\item The \emph{dark} theme mimics the "white on black" scheme seen in \emph{LabSystem Pro} format (and most other high-contrast visualizations), for minimizing eye strain. This calls the \code{\link[=theme_egm_dark]{theme_egm_dark()}} function. DEFAULT.
\item The \emph{light} theme mimics the "black on white" colors seen in the \emph{Prucka} system.
\item \code{NULL} removes any theme, and uses the default \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} settings
}}
}
\value{
Returns an updated \code{ggm} object
}
\description{
Using \code{add_colors()} is part of the theme process for a \code{ggm}
object, which in turn is a visual representation of an \code{egm} object. Often,
the \code{egm} dataset will contain default colors based on where the signal
data was brought in from. \code{add_colors()} can allow customization of those
features to some degree based on \emph{opinionated} color palettes.
}
\details{
Currently, the color choices are individual decided based on the
channel source (e.g. lead) and are inspired by some modern palettes. The
eventual goal for this function is to accept a multitude of palette options
using heuristics similar to what is found in \code{{ggplot2}} or other graphing
packages.
}
