% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_data_package_citations.R
\name{list_data_package_citations}
\alias{list_data_package_citations}
\title{List data package citations}
\usage{
list_data_package_citations(
  packageId,
  as = "data.frame",
  list_all = FALSE,
  env = "production"
)
}
\arguments{
\item{packageId}{(character) Data package identifier}

\item{as}{(character) Format of the returned object. Can be: "data.frame" 
or "xml".}

\item{list_all}{(logical) Return all citations within a data package series?}

\item{env}{(character) Repository environment. Can be: "production",
"staging", or "development".}
}
\value{
(data.frame or xml_document) A list of journal citations
}
\description{
List data package citations
}
\examples{
\dontrun{

# List citations
journalCitations <- list_data_package_citations("edi.845.1")
}
}
\seealso{
Other Journal Citations: 
\code{\link{create_journal_citation}()},
\code{\link{delete_journal_citation}()},
\code{\link{get_journal_citation}()},
\code{\link{list_principal_owner_citations}()}
}
\concept{Journal Citations}
