% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_databases.R
\name{compare_databases}
\alias{compare_databases}
\title{Compare multiple EDC database extractions}
\usage{
compare_databases(databases, fun_read = read_trialmaster, ...)
}
\arguments{
\item{databases}{file paths to read using \code{fun_read}. Can also be a list of \code{edc_database} objects.}

\item{fun_read}{Reading function to use on \code{databases}}

\item{...}{arguments passed to \code{fun_read}}
}
\value{
a list of \code{table} (a \code{gt} object with tooltips) and \code{plot} (a \code{patchwork} of ggplots)
}
\description{
Compares several EDC database extractions and returns:
}
\details{
\itemize{
\item a summary table of the detected differences in datasets/columns presence
\item a summary plot of the differences in number of rows, columns, patients, and rows per patient
}
}
\examples{
#list of 3 edc_databases, each being a list of multiple datasets
databases = edc_example_multiple() 

comparison = compare_databases(databases)
comparison$table
comparison$plot

#in real world, you should better use paths with a reader function:
\dontrun{
  databases = c(
    "data/MYPROJECT_ExportTemplate_xxx_SAS_XPORT_2024_06_01_12_00.zip",
    "data/MYPROJECT_ExportTemplate_xxx_SAS_XPORT_2024_08_01_12_00.zip",
    "data/MYPROJECT_ExportTemplate_xxx_SAS_XPORT_2024_09_01_12_00.zip",
  )
  #`pw` is passed to `read_trialmaster()`
  comparison = compare_databases(databases, fun_read=read_trialmaster, pw="the_password")
}
}
