% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlation.R
\name{correlation}
\alias{correlation}
\alias{correlation.default}
\alias{correlation.formula}
\title{Measures of feature correlation}
\usage{
correlation(...)

\method{correlation}{default}(x, y, measures = "all",
  summary = c("mean", "sd"), ...)

\method{correlation}{formula}(formula, data, measures = "all",
  summary = c("mean", "sd"), ...)
}
\arguments{
\item{...}{Not used.}

\item{x}{A data.frame contained only the input attributes.}

\item{y}{A response vector with one value for each row/component of x.}

\item{measures}{A list of measures names or \code{"all"} to include all them.}

\item{summary}{A list of summarization functions or empty for all values. See
\link{summarization} method to more information. (Default: 
\code{c("mean", "sd")})}

\item{formula}{A formula to define the output column.}

\item{data}{A data.frame dataset contained the input and output attributes.}
}
\value{
A list named by the requested correlation measure.
}
\description{
Regression task. These measures calculate the correlation of the values of 
the features to the outputs. If at least one feature is highly correlated to 
the output, this indicates that simpler functions can be fitted to the data.
}
\details{
The following measures are allowed for this method:
 \describe{
   \item{"C1"}{Maximum feature correlation to the output (C1) calculate the 
     maximum absolute value of the Spearman correlation between each feature 
     and the outputs.}
   \item{"C2"}{Average feature correlation to the output (C2) computes the 
     average of the Spearman correlations of all features to the output.}
   \item{"C3"}{Individual feature efficiency (C3) calculates, for each 
     feature, the number of examples that must be removed from the dataset 
     until a high Spearman correlation value to the output is achieved.}
   \item{"C4"}{Collective feature efficiency (C4) computes the ratio of 
     examples removed from the dataset based on an iterative process of 
     linear fitting between the features and the target attribute.}
 }
}
\examples{
## Extract all correlation measures for regression task
data(cars)
correlation(speed ~ ., cars)
}
\references{
Ana C Lorena and Aron I Maciel and Pericles B C Miranda and Ivan G Costa and
   Ricardo B C Prudencio. (2018). Data complexity meta-features for 
   regression problems. Machine Learning, 107, 1, 209--246.
}
\seealso{
Other complexity-measures: \code{\link{balance}},
  \code{\link{dimensionality}}, \code{\link{linearity}},
  \code{\link{neighborhood}}, \code{\link{network}},
  \code{\link{overlapping}}, \code{\link{smoothness}}
}
\concept{complexity-measures}
