% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetCmat.R
\name{GetCmat}
\alias{GetCmat}
\title{GetCmat}
\usage{
GetCmat(CubeCP, RV = TRUE)
}
\arguments{
\item{CubeCP}{A 3D array of cross-product matrices}

\item{RV}{Boolean, if TRUE, GetCmat computes the matrix of the RV coefficients between all the slices of the 3D array, otherwise, GetCmat computes a scalar product.}
}
\value{
A matrix of either RV coefficients or scalar products.
}
\description{
Computes the RV coefficient matrix
}
\examples{
\donttest{
D3 <- array(c(0, 1, 2, 1, 0, 1, 2, 1, 0, 
              0, 3, 3, 3, 0, 3, 3, 3, 0), 
            dim = c(3, 3, 2))
GetCmat(D3)             
}
}
