% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/did_cde.R
\name{cde_did_aipw}
\alias{cde_did_aipw}
\title{Initialize an AIPW DID-CDE estimator}
\usage{
cde_did_aipw(
  base_mediator,
  trim = c(0.01, 0.99),
  aipw_blip = TRUE,
  on_treated = FALSE
)
}
\arguments{
\item{base_mediator}{The (unquoted) name of the variable that
measures the mediator at baseline.}

\item{trim}{A vector of length 2 indicating what quantiles of the
propensity scores should be trimmed. By default this is \code{c(0.01, 0.99)} meaning that the top and bottom 1\% of propensity scores are
trunctated to these quantiles. If NULL, no trimming occurs.}

\item{aipw_blip}{If \code{TRUE} (the default), augmented inverse probability weighting
estimators will be used to estimate intermediate outcome
regressions (blip functions).}

\item{on_treated}{If \code{FALSE} (the defafult), the effects are
average effects conditional on the levels of the baseline mediator.
If \code{TRUE}, the effects are conditional on the treated path. For
difference in identficiation, see Details below.}
}
\description{
Initializes the specification of a difference-in-differences
estimator for the CDE based on an augmented inverse probability
weighting.
}
\details{
This function, unlike other CDE estimators in the package, only
returns the estimated effects of the first treatment variable.
These effects are conditional on the baseline value of the mediator
(\code{base_mediator}) when \code{on_treated} is \code{TRUE}. A marginalized CDE
estimand is also estimated. When \code{on_treated} is \code{FALSE}, these
estimates are conditional on the entire "treated" history.
Identification  requirements are slightly different between these
two cases. When \code{on_treated} is \code{FALSE}, the confounders for the
mediator cannot be affected by treatment. See Blackwell et al
(2022) for more information.
}
