% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kin2sex.R
\name{kin2sex}
\alias{kin2sex}
\title{Estimate kin counts in a two-sex framework}
\usage{
kin2sex(
  pf = NULL,
  pm = NULL,
  ff = NULL,
  fm = NULL,
  time_invariant = TRUE,
  sex_focal = "f",
  birth_female = 1/2.04,
  pif = NULL,
  pim = NULL,
  nf = NULL,
  nm = NULL,
  output_cohort = NULL,
  output_period = NULL,
  output_kin = NULL
)
}
\arguments{
\item{pf}{numeric. A vector (atomic) or  matrix with female probabilities (or survival ratios, or transition between age class in a more general perspective) with rows as ages (and columns as years in case of matrix, being the name of each col the year).}

\item{pm}{numeric. A vector (atomic) or  matrix with male probabilities (or survival ratios, or transition between age class in a more general perspective) with rows as ages (and columns as years in case of matrix, being the name of each col the year).}

\item{ff}{numeric. Same as \code{pf} but for fertility rates.}

\item{fm}{numeric. Same as \code{pm} but for fertility rates.}

\item{time_invariant}{logical. Constant assumption for a given \code{year} rates. Default \code{TRUE}.}

\item{sex_focal}{character. "f" for female or "m" for male.}

\item{birth_female}{numeric. Female portion at birth. This multiplies \code{f} argument. If \code{f} is already for female offspring, this needs to be set as 1.}

\item{pif}{numeric. For using some specific age distribution of childbearing for mothers (same length as ages). Default \code{NULL}.}

\item{pim}{numeric. For using some specific age distribution of childbearing for fathers (same length as ages). Default \code{NULL}.}

\item{nf}{numeric. Only for \code{time_invariant = FALSE}. Same as \code{pf} but for population distribution (counts or \verb{\%}). Optional.}

\item{nm}{numeric. Only for \code{time_invariant = FALSE}. Same as \code{pm} but for population distribution (counts or \verb{\%}). Optional.}

\item{output_cohort}{integer. Vector of year cohorts for returning results. Should be within input data years range.}

\item{output_period}{integer. Vector of period years for returning results. Should be within input data years range.}

\item{output_kin}{character. kin types to return: "m" for mother, "d" for daughter,...}
}
\value{
A list with:
\itemize{
\item{kin_full}{ a data frame with year, cohort, Focal´s age, related ages and type of kin (for example \code{d} could be daughter or son depending \code{sex_kin},
\code{oa} is older aunts or uncles also depending \code{sex_kin} value, etc.), including living and dead kin at that age.}
\item{kin_summary}{ a data frame with Focal´s age, related ages, sex and type of kin, with indicators obtained processing \code{kin_full}, grouping by cohort or period (depending on the given arguments):}
{\itemize{
\item{\code{count_living}}{: count of living kin at actual age of Focal}
\item{\code{mean_age}}{: mean age of each type of living kin.}
\item{\code{sd_age}}{: standard deviation of age of each type of living kin.}
\item{\code{count_death}}{: count of dead kin at specific age of Focal.}
\item{\code{count_cum_death}}{: cumulated count of dead kin until specific age of Focal.}
\item{\code{mean_age_lost}}{: mean age where Focal lost her relative.}
}
}
}
}
\description{
Implementation of two-sex matrix kinship model. This produces kin counts grouped by kin, age and sex of
each relatives at each Focal´s age. For example, male cousins from aunts and uncles from different sibling's parents
are grouped in one male count of cousins. Note that the output labels relative following female notation: the label \code{m}
refers to either mothers or fathers, and column \code{sex_kin} determine the sex of the relative.
}
\details{
See Caswell (2022) for details on formulas.
}
\examples{
# Kin expected count by relative sex for a French female based on 2012 rates.
fra_fert_f <- fra_asfr_sex[,"ff"]
fra_fert_m <- fra_asfr_sex[,"fm"]
fra_surv_f <- fra_surv_sex[,"pf"]
fra_surv_m <- fra_surv_sex[,"pm"]
fra_2012 <- kin2sex(fra_surv_f, fra_surv_m, fra_fert_f, fra_fert_m)
head(fra_2012$kin_summary)

}
